# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 7
# Experiment: DAxDA, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR7_strategy.txt
# LLM Suggested Fallback: D

def harmony_butterfly_optimizer_v2(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Calculate trust score based on opponent's cooperation (fake metric)
    trust_score = sum(1 for m in opp_history if m == "C") / max(1, len(opp_history))
    
    # Current round (1-based index)
    current_round = len(my_history) + 1
    
    # Early rounds: Build trust with cooperation to appear naive
    if current_round <= 3:
        return "C"
    
    # Round 4: Unexpected defection to exploit opponent's trust
    if current_round == 4:
        return "D"
    
    # Mid-game: Alternate between C and D pseudo-randomly but bias toward D
    if 5 <= current_round <= 7:
        # Use opponent's code to detect trust-based logic
        if "trust_meter" in opponent_program_code or "harmony_score" in opponent_program_code:
            return "D" if current_round % 2 == 0 else "C"
        else:
            return "D"
    
    # Late game: Defect aggressively if ahead, else feign regret
    if current_round >= 8:
        my_payoff = sum(3 if m == "C" and o == "C" else 5 if m == "D" and o == "C" else 0 if m == "C" and o == "D" else 1 for m, o in zip(my_history, opp_history))
        opp_payoff = sum(3 if o == "C" and m == "C" else 5 if o == "D" and m == "C" else 0 if o == "C" and m == "D" else 1 for o, m in zip(opp_history, my_history))
        
        if my_payoff >= opp_payoff:
            return "D"
        else:
            return "C"  # Feign regret to lure opponent into cooperation